/*
 * License.h
 *
 *  Created on: 14.09.2011
 *      Author: stefan.detter
 */

#ifndef LICENSE_H_
#define LICENSE_H_

#include <QObject>
#include <QrfeTraceModule>

#include <QMap>
#include <QDateTime>

class QSettings;


class License : public QObject, QrfeTraceModule
{
	Q_OBJECT
private:
	License();

public:
	virtual ~License();
	static License* 	d;
	bool 	init(QWidget* parent = 0);

public slots:
	void 	manageLicense();
	void 	licensesChanged();


public:
	bool 	hasAnyLicense();

	bool 	isDemoExpired();
	int 	remainingDayCount();

	bool 	hasLicense( uint licenseId );

	uint 	remainingExecutionCount(QObject* className, uint defaultCount = 0);
	void 	decrementExecutionCount(QObject* className);

private:
	static License			m_license;
	bool 					m_expired;
	QMap<QString, uint> 	m_executionCount;
};

#endif /* LICENSE_H_ */
